<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Material extends Model 
{

    protected $table = 'materials';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('timestamps', 'softDeletes');

    public function materialType()
    {
        return $this->belongsTo('MaterialType', 'id', 'material_type_id');
    }

    public function services()
    {
        return $this->belongsToMany('Service', 'service_material', 'material_id', 'service_id')->withTimestamps();
    }

    public function technologies()
    {
        return $this->belongsToMany('Technology', 'technology_material', 'material_id', 'technology_id')->withTimestamps();
    }

}